package gov.va.med.mhv.integration.phr.stage.transfer;

import java.util.Date;

/**
 * StageAppointment entity.
 * 
 */

public class StageAppointment extends StageEntity {

	// Fields
	protected String ien;
	protected String clinic;
	protected String status;
	protected String appointmentType;
	protected String clinicphone;
	protected String ekgDateString;
	protected Date ekgDate;
	protected String xrayDateString;
	protected Date xrayDate;
	protected String labDateString;
	protected Date labDate;
	protected String appointmentDateString;
	protected Date appointmentDate;
	protected String currentStatus;
	protected String location;

	/**
	 * default constructor do not provide auto initialization since this class
	 * can be used in findByExample
	 * */
	public StageAppointment() {
		super();
	}

	/** minimal constructor */
	public StageAppointment(Long oplock, Date createdDate, Date modifiedDate, String icn, String stationNumber,
			Long requestMsgCtrlId) {
		super();
		this.oplock = oplock;
		this.createdDate = createdDate;
		this.modifiedDate = modifiedDate;
		this.icn = icn;
		this.stationNumber = stationNumber;
		this.requestMsgCtrlId = requestMsgCtrlId;
	}

	// Property accessors

	public String getIen() {
		return this.ien;
	}

	public void setIen(String ien) {
		this.ien = doubleUnescapeHtml(ien);
	}

	public String getClinic() {
		return this.clinic;
	}

	public void setClinic(String clinic) {
		if (clinic != null) {
			// CR7486 remove leading and trailing spaces
			this.clinic = doubleUnescapeHtml(clinic.trim());
		}
	}

	public String getStatus() {
		return this.status;
	}

	public void setStatus(String status) {
		this.status = doubleUnescapeHtml(status);
	}

	public String getAppointmentType() {
		return this.appointmentType;
	}

	public void setAppointmentType(String appointmentType) {
		this.appointmentType = doubleUnescapeHtml(appointmentType);
	}

	public String getClinicphone() {
		return this.clinicphone;
	}

	public void setClinicphone(String clinicphone) {
		this.clinicphone = doubleUnescapeHtml(clinicphone);
	}

	public Date getLabDate() {
		return labDate;
	}

	public void setLabDate(Date labDate) {
		this.labDate = labDate;
	}

	public String getLabDateString() {
		return labDateString;
	}

	public void setLabDateString(String labDateString) {
		this.labDateString = labDateString;
	}

	public Date getXrayDate() {
		return xrayDate;
	}

	public void setXrayDate(Date xrayDate) {
		this.xrayDate = xrayDate;
	}

	public String getXrayDateString() {
		return xrayDateString;
	}

	public void setXrayDateString(String xrayDateString) {
		this.xrayDateString = xrayDateString;
	}

	public Date getEkgDate() {
		return ekgDate;
	}

	public void setEkgDate(Date ekgDate) {
		this.ekgDate = ekgDate;
	}

	public String getEkgDateString() {
		return ekgDateString;
	}

	public void setEkgDateString(String ekgDateString) {
		this.ekgDateString = ekgDateString;
	}

	public Date getAppointmentDate() {
		return appointmentDate;
	}

	public void setAppointmentDate(Date appointmentDate) {
		this.appointmentDate = appointmentDate;
	}

	public String getAppointmentDateString() {
		return appointmentDateString;
	}

	public void setAppointmentDateString(String appointmentDateString) {
		this.appointmentDateString = appointmentDateString;
	}

	public String getCurrentStatus() {
		return currentStatus;
	}

	public void setCurrentStatus(String currentStatus) {
		this.currentStatus = doubleUnescapeHtml(currentStatus);
	}

	public String getLocation() {
		return location;
	}

	public void setLocation(String location) {
		this.location = doubleUnescapeHtml(location);
	}

	public String toString() {
		return "StageAppointment{" + "ien='" + ien + '\'' + ", clinic='" + clinic + '\'' + ", status='" + status + '\''
				+ ", appointmentType='" + appointmentType + '\'' + ", clinicphone='" + clinicphone + '\''
				+ ", ekgDateString='" + ekgDateString + '\'' + ", ekgDate=" + ekgDate + ", xrayDateString='"
				+ xrayDateString + '\'' + ", xrayDate=" + xrayDate + ", labDateString='" + labDateString + '\''
				+ ", labDate=" + labDate + ", appointmentDateString='" + appointmentDateString + '\''
				+ ", appointmentDate=" + appointmentDate + ", currentStatus='" + currentStatus + '\'' + ", location='"
				+ location + '\'' + '}';
	}

}